package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备信息对象 t_device_info
 *
 * @author zehong
 * @date 2022-01-27
 */
public class TDeviceInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备id */
    private Long deviceId;

    /** 场站id*/
    private Long siteStationId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String deviceCode;

    /** 所在地址 */
    @Excel(name = "所在地址")
    private String deviceAddr;

    /** 设备型号 */
    @Excel(name = "设备型号")
    private String deviceModel;

    /** 设备类型：1.阀井 2.调压箱 3.巡检员 4.视频 */
    @Excel(name = "设备类型")
    private String deviceType;

    /** 权属单位 */
    private Long beyondEnterpriseId;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    /** 经度 */
    @Excel(name = "经度")
    private String longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private String latitude;

    /** 设备图片路径 */
    private String iconUrl;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 安装时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "安装时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date installationTime;

    /** 最后巡检时间 */
    private Date inspectionTime;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    private String remarks;

    /** 关联设备类型  1设备  2场站*/
    private String relationDeviceType;


    public Long getSiteStationId() {
        return siteStationId;
    }

    public void setSiteStationId(Long siteStationId) {
        this.siteStationId = siteStationId;
    }

    public String getRelationDeviceType() {
        return relationDeviceType;
    }

    public void setRelationDeviceType(String relationDeviceType) {
        this.relationDeviceType = relationDeviceType;
    }

    public void setDeviceId(Long deviceId)
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId()
    {
        return deviceId;
    }
    public void setDeviceName(String deviceName)
    {
        this.deviceName = deviceName;
    }

    public String getDeviceName()
    {
        return deviceName;
    }
    public void setDeviceCode(String deviceCode)
    {
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode()
    {
        return deviceCode;
    }
    public void setDeviceAddr(String deviceAddr)
    {
        this.deviceAddr = deviceAddr;
    }

    public String getDeviceAddr()
    {
        return deviceAddr;
    }
    public void setDeviceModel(String deviceModel)
    {
        this.deviceModel = deviceModel;
    }

    public String getDeviceModel()
    {
        return deviceModel;
    }
    public void setDeviceType(String deviceType)
    {
        this.deviceType = deviceType;
    }

    public String getDeviceType()
    {
        return deviceType;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setIconUrl(String iconUrl)
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl()
    {
        return iconUrl;
    }
    public void setLinkman(String linkman)
    {
        this.linkman = linkman;
    }

    public String getLinkman()
    {
        return linkman;
    }
    public void setPhone(String phone)
    {
        this.phone = phone;
    }

    public String getPhone()
    {
        return phone;
    }
    public void setInstallationTime(Date installationTime)
    {
        this.installationTime = installationTime;
    }

    public Date getInstallationTime()
    {
        return installationTime;
    }
    public void setInspectionTime(Date inspectionTime)
    {
        this.inspectionTime = inspectionTime;
    }

    public Date getInspectionTime()
    {
        return inspectionTime;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TDeviceInfo{" +
                "deviceId=" + deviceId +
                ", siteStationId=" + siteStationId +
                ", deviceName='" + deviceName + '\'' +
                ", deviceCode='" + deviceCode + '\'' +
                ", deviceAddr='" + deviceAddr + '\'' +
                ", deviceModel='" + deviceModel + '\'' +
                ", deviceType='" + deviceType + '\'' +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", beyondEnterpriseName='" + beyondEnterpriseName + '\'' +
                ", longitude='" + longitude + '\'' +
                ", latitude='" + latitude + '\'' +
                ", iconUrl='" + iconUrl + '\'' +
                ", linkman='" + linkman + '\'' +
                ", phone='" + phone + '\'' +
                ", installationTime=" + installationTime +
                ", inspectionTime=" + inspectionTime +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                ", relationDeviceType='" + relationDeviceType + '\'' +
                '}';
    }
}
