package com.zehong.web.controller.statistic;

import com.zehong.common.config.GassafetyProgressConfig;
import com.zehong.common.constant.Constants;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.utils.StringUtils;
import com.zehong.common.utils.file.FileUploadUtils;
import com.zehong.common.utils.file.FileUtils;
import com.zehong.framework.config.ServerConfig;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.domain.TVideoManager;
import com.zehong.system.domain.form.THiddenDangerStandingBookForm;
import com.zehong.system.domain.form.TTroubleStandingBookForm;
import com.zehong.system.domain.vo.HomepageVo;
import com.zehong.system.domain.vo.THiddenDangerStandingBookVo;
import com.zehong.system.domain.vo.TTroubleStandingBookVo;
import com.zehong.system.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 统计分析
 * 
 * @author zehong
 */
@RestController
@RequestMapping("/statistic")
public class StatisticController
{
    private static final Logger log = LoggerFactory.getLogger(StatisticController.class);

    @Autowired
    private ITVideoManagerService tVideoManagerService;
    @Autowired
    private ITSafeEquipmentStandingBookService tSafeEquipmentStandingBookService;
    @Autowired
    private ITTroubleStandingBookService tTroubleStandingBookService;
    @Autowired
    private ITHiddenDangerStandingBookService tHiddenDangerStandingBookService;
    @Autowired
    private ITComplainDealService tComplainDealService;
    @Autowired
    private ITWorkOrderService tWorkOrderService;

    /**
     * 燃气事故台账统计
     */
    @GetMapping("/troubleStatistic")
    public AjaxResult troubleStatistic()
    {
        return AjaxResult.success(tTroubleStandingBookService.selectTTroubleStandingBookStatistic());
    }

    /**
     * 隐患整治台账统计
     */
    @GetMapping("/hiddenStatistic")
    public AjaxResult hiddenStatistic()
    {
        return AjaxResult.success(tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookStatistic());
    }

    /**
     * 首页统计
     */
    @GetMapping("/homepageStatistic")
    public AjaxResult homepageStatistic()
    {
        HomepageVo homepageVo = new HomepageVo();

        homepageVo = tComplainDealService.countTComplainDeal();
        homepageVo.setTaskTotal(tWorkOrderService.countTWorkOrder().getTaskTotal());
        homepageVo.setTaskFeedbackTotal(tWorkOrderService.countTWorkOrder().getTaskFeedbackTotal());

        List<TVideoManager> tVideoManagerList = tVideoManagerService.selectTVideoManagerList(null);
        List<TSafeEquipmentStandingBook> tSafeEquipmentStandingBookList = tSafeEquipmentStandingBookService.selectTSafeEquipmentStandingBookList(null);
        List<TTroubleStandingBook> tTroubleStandingBookList = tTroubleStandingBookService.selectTTroubleStandingBookList(null);
        List<THiddenDangerStandingBook> tHiddenDangerStandingBookList = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(null);

        homepageVo.setVideoTotal(tVideoManagerList.size());
        homepageVo.setEquipmentTotal(tSafeEquipmentStandingBookList.size());
        homepageVo.setTroubleTotal(tTroubleStandingBookList.size());
        homepageVo.setHiddenTotal(tHiddenDangerStandingBookList.size());

        return AjaxResult.success(homepageVo);
    }

}
