package com.zehong.web.controller.standingBook;

import java.util.List;

import com.zehong.system.domain.form.TTroubleStandingBookForm;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.service.ITTroubleStandingBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事故台账Controller
 * 
 * @author zehong
 * @date 2022-02-09
 */
@RestController
@RequestMapping("/standingBook/trouble")
public class TTroubleStandingBookController extends BaseController
{
    @Autowired
    private ITTroubleStandingBookService tTroubleStandingBookService;

    /**
     * 查询事故台账列表
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:list')")
    @GetMapping("/list")
    public TableDataInfo list(TTroubleStandingBookForm tTroubleStandingBook)
    {
        startPage();
        List<TTroubleStandingBook> list = tTroubleStandingBookService.selectTTroubleStandingBookList(tTroubleStandingBook);
        return getDataTable(list);
    }

    /**
     * 导出事故台账列表
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:export')")
    @Log(title = "事故台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTroubleStandingBookForm tTroubleStandingBook)
    {
        List<TTroubleStandingBook> list = tTroubleStandingBookService.selectTTroubleStandingBookList(tTroubleStandingBook);
        ExcelUtil<TTroubleStandingBook> util = new ExcelUtil<TTroubleStandingBook>(TTroubleStandingBook.class);
        return util.exportExcel(list, "事故台账数据");
    }

    /**
     * 获取事故台账详细信息
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:query')")
    @GetMapping(value = "/{troubleId}")
    public AjaxResult getInfo(@PathVariable("troubleId") Long troubleId)
    {
        return AjaxResult.success(tTroubleStandingBookService.selectTTroubleStandingBookById(troubleId));
    }

    /**
     * 新增事故台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:add')")
    @Log(title = "事故台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTroubleStandingBook tTroubleStandingBook)
    {
        return toAjax(tTroubleStandingBookService.insertTTroubleStandingBook(tTroubleStandingBook));
    }

    /**
     * 修改事故台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:edit')")
    @Log(title = "事故台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTroubleStandingBook tTroubleStandingBook)
    {
        return toAjax(tTroubleStandingBookService.updateTTroubleStandingBook(tTroubleStandingBook));
    }

    /**
     * 删除事故台账
     */
    @PreAuthorize("@ss.hasPermi('standingBook:trouble:remove')")
    @Log(title = "事故台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{troubleIds}")
    public AjaxResult remove(@PathVariable Long[] troubleIds)
    {
        return toAjax(tTroubleStandingBookService.deleteTTroubleStandingBookByIds(troubleIds));
    }
}
