import request from '@/utils/request'

// 查询视频管理列表
export function listManager(query) {
  return request({
    url: '/system/manager/list',
    method: 'get',
    params: query
  })
}

//获取视频树
export function getVideoTree(query) {
  return request({
    url: '/system/manager/getVideoTree',
    method: 'get',
    params: query
  })
}

// 查询视频管理详细
export function getManager(videoManagerId) {
  return request({
    url: '/system/manager/' + videoManagerId,
    method: 'get'
  })
}

// 新增视频管理
export function addManager(data) {
  return request({
    url: '/system/manager',
    method: 'post',
    data: data
  })
}

// 修改视频管理
export function updateManager(data) {
  return request({
    url: '/system/manager',
    method: 'put',
    data: data
  })
}

// 删除视频管理
export function delManager(videoManagerId) {
  return request({
    url: '/system/manager/' + videoManagerId,
    method: 'delete'
  })
}

// 导出视频管理
export function exportManager(query) {
  return request({
    url: '/system/manager/export',
    method: 'get',
    params: query
  })
}
