import request from '@/utils/request'

// 查询隐患整治台账列表
export function listHidden(query) {
  return request({
    url: '/standingBook/hidden/list',
    method: 'get',
    params: query
  })
}

// 查询隐患整治台账详细
export function getHidden(hiddenId) {
  return request({
    url: '/standingBook/hidden/' + hiddenId,
    method: 'get'
  })
}

// 新增隐患整治台账
export function addHidden(data) {
  return request({
    url: '/standingBook/hidden',
    method: 'post',
    data: data
  })
}

// 修改隐患整治台账
export function updateHidden(data) {
  return request({
    url: '/standingBook/hidden',
    method: 'put',
    data: data
  })
}

// 删除隐患整治台账
export function delHidden(hiddenId) {
  return request({
    url: '/standingBook/hidden/' + hiddenId,
    method: 'delete'
  })
}

// 导出隐患整治台账
export function exportHidden(query) {
  return request({
    url: '/standingBook/hidden/export',
    method: 'get',
    params: query
  })
}