import request from '@/utils/request'

// 查询场站信息列表
export function listStation(query) {
  return request({
    url: '/supervise/station/list',
    method: 'get',
    params: query
  })
}

// 查询场站信息详细
export function getStation(siteStationId) {
  return request({
    url: '/supervise/station/' + siteStationId,
    method: 'get'
  })
}

// 新增场站信息
export function addStation(data) {
  return request({
    url: '/supervise/station',
    method: 'post',
    data: data
  })
}

// 修改场站信息
export function updateStation(data) {
  return request({
    url: '/supervise/station',
    method: 'put',
    data: data
  })
}

// 删除场站信息
export function delStation(siteStationId) {
  return request({
    url: '/supervise/station/' + siteStationId,
    method: 'delete'
  })
}

// 导出场站信息
export function exportStation(query) {
  return request({
    url: '/supervise/station/export',
    method: 'get',
    params: query
  })
}

// 企业信息查询(下拉框)
export function selectTEnterprise() {
  return request({
    url: '/regulation/supervise/selectTEnterprise',
    method: 'get'
  })
}
