import request from '@/utils/request'

// 查询企业信息列表
export function listInfo(query) {
  return request({
    url: '/regulation/info/list',
    method: 'get',
    params: query
  })
}

// 查询企业所有信息
export function enterpriseLists(query) {
  return request({
    url: '/regulation/info/enterpriseLists',
    method: 'get',
    params: query
  })
}



// 查询企业信息详细
export function getInfo(enterpriseId) {
  return request({
    url: '/regulation/info/' + enterpriseId,
    method: 'get'
  })
}

// 新增企业信息
export function addInfo(data) {
  return request({
    url: '/regulation/info',
    method: 'post',
    data: data
  })
}

// 修改企业信息
export function updateInfo(data) {
  return request({
    url: '/regulation/info',
    method: 'put',
    data: data
  })
}

// 删除企业信息
export function delInfo(enterpriseId) {
  return request({
    url: '/regulation/info/' + enterpriseId,
    method: 'delete'
  })
}

// 导出企业信息
export function exportInfo(query) {
  return request({
    url: '/regulation/info/export',
    method: 'get',
    params: query
  })
}
