package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.form.TSafeEquipmentStandingBookForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSafeEquipmentStandingBookMapper;
import com.zehong.system.domain.TSafeEquipmentStandingBook;
import com.zehong.system.service.ITSafeEquipmentStandingBookService;

/**
 * 用户加装安全装置台账Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-09
 */
@Service
public class TSafeEquipmentStandingBookServiceImpl implements ITSafeEquipmentStandingBookService 
{
    @Autowired
    private TSafeEquipmentStandingBookMapper tSafeEquipmentStandingBookMapper;

    /**
     * 查询用户加装安全装置台账
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 用户加装安全装置台账
     */
    @Override
    public TSafeEquipmentStandingBook selectTSafeEquipmentStandingBookById(Long safeEquipmentId)
    {
        return tSafeEquipmentStandingBookMapper.selectTSafeEquipmentStandingBookById(safeEquipmentId);
    }

    /**
     * 查询用户加装安全装置台账列表
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 用户加装安全装置台账
     */
    @Override
    public List<TSafeEquipmentStandingBook> selectTSafeEquipmentStandingBookList(TSafeEquipmentStandingBookForm tSafeEquipmentStandingBook)
    {
        return tSafeEquipmentStandingBookMapper.selectTSafeEquipmentStandingBookList(tSafeEquipmentStandingBook);
    }

    /**
     * 新增用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    @Override
    public int insertTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        tSafeEquipmentStandingBook.setCreateTime(DateUtils.getNowDate());
        return tSafeEquipmentStandingBookMapper.insertTSafeEquipmentStandingBook(tSafeEquipmentStandingBook);
    }

    /**
     * 修改用户加装安全装置台账
     * 
     * @param tSafeEquipmentStandingBook 用户加装安全装置台账
     * @return 结果
     */
    @Override
    public int updateTSafeEquipmentStandingBook(TSafeEquipmentStandingBook tSafeEquipmentStandingBook)
    {
        tSafeEquipmentStandingBook.setUpdateTime(DateUtils.getNowDate());
        return tSafeEquipmentStandingBookMapper.updateTSafeEquipmentStandingBook(tSafeEquipmentStandingBook);
    }

    /**
     * 批量删除用户加装安全装置台账
     * 
     * @param safeEquipmentIds 需要删除的用户加装安全装置台账ID
     * @return 结果
     */
    @Override
    public int deleteTSafeEquipmentStandingBookByIds(Long[] safeEquipmentIds)
    {
        return tSafeEquipmentStandingBookMapper.deleteTSafeEquipmentStandingBookByIds(safeEquipmentIds);
    }

    /**
     * 删除用户加装安全装置台账信息
     * 
     * @param safeEquipmentId 用户加装安全装置台账ID
     * @return 结果
     */
    @Override
    public int deleteTSafeEquipmentStandingBookById(Long safeEquipmentId)
    {
        return tSafeEquipmentStandingBookMapper.deleteTSafeEquipmentStandingBookById(safeEquipmentId);
    }
}
