package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TEnterpriseInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmployedPeopleInfoMapper;
import com.zehong.system.domain.TEmployedPeopleInfo;
import com.zehong.system.service.ITEmployedPeopleInfoService;

/**
 * 从业人员信息Service业务层处理
 *
 * @author zehong
 * @date 2022-01-25
 */
@Service
public class TEmployedPeopleInfoServiceImpl implements ITEmployedPeopleInfoService
{
    @Autowired
    private TEmployedPeopleInfoMapper tEmployedPeopleInfoMapper;

    /**
     * 查询从业人员信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 从业人员信息
     */
    @Override
    public TEmployedPeopleInfo selectTEmployedPeopleInfoById(Long employedPeopleId)
    {
        return tEmployedPeopleInfoMapper.selectTEmployedPeopleInfoById(employedPeopleId);
    }

    /**
     * 查询从业人员信息列表
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 从业人员信息
     */
    @Override
    public List<TEmployedPeopleInfo> selectTEmployedPeopleInfoList(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        return tEmployedPeopleInfoMapper.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
    }

    /**
     * 新增从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    @Override
    public int insertTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        tEmployedPeopleInfo.setCreateTime(DateUtils.getNowDate());
        return tEmployedPeopleInfoMapper.insertTEmployedPeopleInfo(tEmployedPeopleInfo);
    }

    /**
     * 修改从业人员信息
     *
     * @param tEmployedPeopleInfo 从业人员信息
     * @return 结果
     */
    @Override
    public int updateTEmployedPeopleInfo(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        tEmployedPeopleInfo.setUpdateTime(DateUtils.getNowDate());
        return tEmployedPeopleInfoMapper.updateTEmployedPeopleInfo(tEmployedPeopleInfo);
    }

    /**
     * 批量删除从业人员信息
     *
     * @param employedPeopleIds 需要删除的从业人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoByIds(Long[] employedPeopleIds)
    {
        return tEmployedPeopleInfoMapper.deleteTEmployedPeopleInfoByIds(employedPeopleIds);
    }

    /**
     * 删除从业人员信息信息
     *
     * @param employedPeopleId 从业人员信息ID
     * @return 结果
     */
    @Override
    public int deleteTEmployedPeopleInfoById(Long employedPeopleId)
    {
        return tEmployedPeopleInfoMapper.deleteTEmployedPeopleInfoById(employedPeopleId);
    }

    /**
     * 企业信息查询(下拉框数据)
     * @return
     */
    @Override
    public List<TEnterpriseInfo> selectTEnterprise() {
        return tEmployedPeopleInfoMapper.selectTEnterprise();
    }

    /**
     * 根据企业id查询企业名称
     * @param bId
     * @return
     */
    @Override
    public String selectEnterpriseName(Long bId) {
        String s = tEmployedPeopleInfoMapper.selectEnterpriseName(bId);
        return s;
    }
}
