package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDetectorUserMapper;
import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.service.ITDetectorUserService;

/**
 * 燃气用户Service业务层处理
 * 
 * @author zehong
 * @date 2022-02-07
 */
@Service
public class TDetectorUserServiceImpl implements ITDetectorUserService 
{
    @Autowired
    private TDetectorUserMapper tDetectorUserMapper;

    /**
     * 查询燃气用户
     * 
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    @Override
    public TDetectorUser selectTDetectorUserById(Long userId)
    {
        return tDetectorUserMapper.selectTDetectorUserById(userId);
    }

    /**
     * 查询燃气用户列表
     * 
     * @param tDetectorUser 燃气用户
     * @return 燃气用户
     */
    @Override
    public List<TDetectorUser> selectTDetectorUserList(TDetectorUser tDetectorUser)
    {
        return tDetectorUserMapper.selectTDetectorUserList(tDetectorUser);
    }

    /**
     * 新增燃气用户
     * 
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    @Override
    public int insertTDetectorUser(TDetectorUser tDetectorUser)
    {
        return tDetectorUserMapper.insertTDetectorUser(tDetectorUser);
    }

    /**
     * 修改燃气用户
     * 
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    @Override
    public int updateTDetectorUser(TDetectorUser tDetectorUser)
    {
        return tDetectorUserMapper.updateTDetectorUser(tDetectorUser);
    }

    /**
     * 批量删除燃气用户
     * 
     * @param userIds 需要删除的燃气用户ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorUserByIds(Long[] userIds)
    {
        return tDetectorUserMapper.deleteTDetectorUserByIds(userIds);
    }

    /**
     * 删除燃气用户信息
     * 
     * @param userId 燃气用户ID
     * @return 结果
     */
    @Override
    public int deleteTDetectorUserById(Long userId)
    {
        return tDetectorUserMapper.deleteTDetectorUserById(userId);
    }
}
