package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDetectorUser;

/**
 * 燃气用户Service接口
 * 
 * @author zehong
 * @date 2022-02-07
 */
public interface ITDetectorUserService 
{
    /**
     * 查询燃气用户
     * 
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    public TDetectorUser selectTDetectorUserById(Long userId);

    /**
     * 查询燃气用户列表
     * 
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> selectTDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 新增燃气用户
     * 
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int insertTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 修改燃气用户
     * 
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int updateTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 批量删除燃气用户
     * 
     * @param userIds 需要删除的燃气用户ID
     * @return 结果
     */
    public int deleteTDetectorUserByIds(Long[] userIds);

    /**
     * 删除燃气用户信息
     * 
     * @param userId 燃气用户ID
     * @return 结果
     */
    public int deleteTDetectorUserById(Long userId);
}
