package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.domain.vo.HomepageVo;

/**
 * 燃气任务Mapper接口
 * 
 * @author zehong
 * @date 2022-02-10
 */
public interface TWorkOrderMapper 
{
    /**
     * 查询燃气任务
     * 
     * @param workId 燃气任务ID
     * @return 燃气任务
     */
    public TWorkOrder selectTWorkOrderById(Long workId);

    /**
     * 查询燃气任务列表
     * 
     * @param tWorkOrder 燃气任务
     * @return 燃气任务集合
     */
    public List<TWorkOrder> selectTWorkOrderList(TWorkOrder tWorkOrder);

    /**
     * 燃气任务统计
     *
     * @return 燃气任务统计
     */
    public HomepageVo countTWorkOrder();

    /**
     * 新增燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    public int insertTWorkOrder(TWorkOrder tWorkOrder);

    /**
     * 修改燃气任务
     * 
     * @param tWorkOrder 燃气任务
     * @return 结果
     */
    public int updateTWorkOrder(TWorkOrder tWorkOrder);

    /**
     * 删除燃气任务
     * 
     * @param workId 燃气任务ID
     * @return 结果
     */
    public int deleteTWorkOrderById(Long workId);

    /**
     * 批量删除燃气任务
     * 
     * @param workIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTWorkOrderByIds(Long[] workIds);
}
