package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPipeInfo;

/**
 * 管道信息Mapper接口
 *
 * @author zehong
 * @date 2022-01-26
 */
public interface TPipeInfoMapper
{
    /**
     * 查询管道信息
     *
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    public TPipeInfo selectTPipeInfoById(Long pipeId);

    /**
     * 查询管道信息列表
     *
     * @param tPipeInfo 管道信息
     * @return 管道信息集合
     */
    public List<TPipeInfo> selectTPipeInfoList(TPipeInfo tPipeInfo);

    /**
     * 新增管道信息
     *
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    public int insertTPipeInfo(TPipeInfo tPipeInfo);

    /**
     * 修改管道信息
     *
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    public int updateTPipeInfo(TPipeInfo tPipeInfo);

    /**
     * 删除管道信息
     *
     * @param pipeId 管道信息ID
     * @return 结果
     */
    public int deleteTPipeInfoById(Long pipeId);

    /**
     * 批量删除管道信息
     *
     * @param pipeIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeInfoByIds(Long[] pipeIds);
}
