package com.zehong.system.domain.form;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 事故台账对象 t_trouble_standing_book
 * 
 * @author zehong
 * @date 2022-02-09
 */
@Data
public class TTroubleStandingBookForm
{

    /** 事故名称 */
    private String troubleName;

    /** 事故类型：1.生产安全事故 2.非生产安全事故 */
    private String troubleType;

    /** 是否处理：1.已处理 2.未处理 */
    private String isDeal;

    /** 事故发生起始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date happenDateStart;

    /** 事故发生截止时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date happenDateEnd;

    /** 处理完成起始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date dealDateStart;

    /** 处理完成截止时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date dealDateEnd;

}
