package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 燃气任务对象 t_work_order
 * 
 * @author zehong
 * @date 2022-02-10
 */
public class TWorkOrder extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 任务id */
    private Long workId;

    /** 任务标题 */
    @Excel(name = "任务标题")
    private String workTitle;

    /** 任务类型：1.入户安检 2.巡检 3.报警巡查 4.其他 */
    @Excel(name = "任务类型：1.入户安检 2.巡检 3.报警巡查 4.其他")
    private String workType;

    /** 任务内容 */
    @Excel(name = "任务内容")
    private String workContent;

    /** 创建单位名称 */
    @Excel(name = "创建单位名称")
    private String workCreateEnterpriseName;

    /** 创建单位id */
    @Excel(name = "创建单位id")
    private String workCreateEnterpriseId;

    /** 指派单位名称 */
    @Excel(name = "指派单位名称")
    private String workAssignEnterproseName;

    /** 指派单位id */
    @Excel(name = "指派单位id")
    private Long workAssignEnterproseId;

    /** 指派人 */
    @Excel(name = "指派人")
    private Long workAssignManId;

    /** 指派人id */
    @Excel(name = "指派人id")
    private String workAssignMan;

    /** 任务状态：1.派发中 2.反馈 3.归档 */
    @Excel(name = "任务状态：1.派发中 2.反馈 3.归档")
    private String workStatus;

    /** 巡检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "巡检时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectionDate;

    /** 巡检路线 */
    @Excel(name = "巡检路线")
    private String inspectionRoute;

    /** 问题描述 */
    @Excel(name = "问题描述")
    private String problemDescription;

    /** 图片路径 */
    @Excel(name = "图片路径")
    private String iconUrl;

    /** 整改方案 */
    @Excel(name = "整改方案")
    private String rectificationPlan;

    /** 整改结果 */
    @Excel(name = "整改结果")
    private String rectificationResult;

    /** 责任单位 */
    @Excel(name = "责任单位")
    private String responsibleUnit;

    /** 责任人员 */
    @Excel(name = "责任人员")
    private String responsiblePerson;

    /** 截止日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "截止日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expiryDate;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setWorkId(Long workId) 
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setWorkTitle(String workTitle) 
    {
        this.workTitle = workTitle;
    }

    public String getWorkTitle() 
    {
        return workTitle;
    }
    public void setWorkType(String workType) 
    {
        this.workType = workType;
    }

    public String getWorkType() 
    {
        return workType;
    }
    public void setWorkContent(String workContent) 
    {
        this.workContent = workContent;
    }

    public String getWorkContent() 
    {
        return workContent;
    }
    public void setWorkCreateEnterpriseName(String workCreateEnterpriseName) 
    {
        this.workCreateEnterpriseName = workCreateEnterpriseName;
    }

    public String getWorkCreateEnterpriseName() 
    {
        return workCreateEnterpriseName;
    }
    public void setWorkCreateEnterpriseId(String workCreateEnterpriseId) 
    {
        this.workCreateEnterpriseId = workCreateEnterpriseId;
    }

    public String getWorkCreateEnterpriseId() 
    {
        return workCreateEnterpriseId;
    }
    public void setWorkAssignEnterproseName(String workAssignEnterproseName) 
    {
        this.workAssignEnterproseName = workAssignEnterproseName;
    }

    public String getWorkAssignEnterproseName() 
    {
        return workAssignEnterproseName;
    }
    public void setWorkAssignEnterproseId(Long workAssignEnterproseId) 
    {
        this.workAssignEnterproseId = workAssignEnterproseId;
    }

    public Long getWorkAssignEnterproseId() 
    {
        return workAssignEnterproseId;
    }
    public void setWorkAssignManId(Long workAssignManId) 
    {
        this.workAssignManId = workAssignManId;
    }

    public Long getWorkAssignManId() 
    {
        return workAssignManId;
    }
    public void setWorkAssignMan(String workAssignMan) 
    {
        this.workAssignMan = workAssignMan;
    }

    public String getWorkAssignMan() 
    {
        return workAssignMan;
    }
    public void setWorkStatus(String workStatus) 
    {
        this.workStatus = workStatus;
    }

    public String getWorkStatus() 
    {
        return workStatus;
    }
    public void setInspectionDate(Date inspectionDate) 
    {
        this.inspectionDate = inspectionDate;
    }

    public Date getInspectionDate() 
    {
        return inspectionDate;
    }
    public void setInspectionRoute(String inspectionRoute) 
    {
        this.inspectionRoute = inspectionRoute;
    }

    public String getInspectionRoute() 
    {
        return inspectionRoute;
    }
    public void setProblemDescription(String problemDescription) 
    {
        this.problemDescription = problemDescription;
    }

    public String getProblemDescription() 
    {
        return problemDescription;
    }
    public void setIconUrl(String iconUrl) 
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() 
    {
        return iconUrl;
    }
    public void setRectificationPlan(String rectificationPlan) 
    {
        this.rectificationPlan = rectificationPlan;
    }

    public String getRectificationPlan() 
    {
        return rectificationPlan;
    }
    public void setRectificationResult(String rectificationResult) 
    {
        this.rectificationResult = rectificationResult;
    }

    public String getRectificationResult() 
    {
        return rectificationResult;
    }
    public void setResponsibleUnit(String responsibleUnit) 
    {
        this.responsibleUnit = responsibleUnit;
    }

    public String getResponsibleUnit() 
    {
        return responsibleUnit;
    }
    public void setResponsiblePerson(String responsiblePerson) 
    {
        this.responsiblePerson = responsiblePerson;
    }

    public String getResponsiblePerson() 
    {
        return responsiblePerson;
    }
    public void setExpiryDate(Date expiryDate) 
    {
        this.expiryDate = expiryDate;
    }

    public Date getExpiryDate() 
    {
        return expiryDate;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("workId", getWorkId())
            .append("workTitle", getWorkTitle())
            .append("workType", getWorkType())
            .append("workContent", getWorkContent())
            .append("workCreateEnterpriseName", getWorkCreateEnterpriseName())
            .append("workCreateEnterpriseId", getWorkCreateEnterpriseId())
            .append("workAssignEnterproseName", getWorkAssignEnterproseName())
            .append("workAssignEnterproseId", getWorkAssignEnterproseId())
            .append("workAssignManId", getWorkAssignManId())
            .append("workAssignMan", getWorkAssignMan())
            .append("workStatus", getWorkStatus())
            .append("inspectionDate", getInspectionDate())
            .append("inspectionRoute", getInspectionRoute())
            .append("problemDescription", getProblemDescription())
            .append("iconUrl", getIconUrl())
            .append("rectificationPlan", getRectificationPlan())
            .append("rectificationResult", getRectificationResult())
            .append("responsibleUnit", getResponsibleUnit())
            .append("responsiblePerson", getResponsiblePerson())
            .append("expiryDate", getExpiryDate())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
