package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 事件处置对象 t_event_info
 * 
 * @author zehong
 * @date 2022-02-11
 */
public class TEventInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 事件id */
    private Long eventId;

    /** 事件名称 */
    @Excel(name = "事件名称")
    private String eventTitle;

    /** 事件类型：1.泄漏 2.火灾 3.爆炸 */
    @Excel(name = "事件类型：1.泄漏 2.火灾 3.爆炸")
    private String eventType;

    /** 事件等级 */
    @Excel(name = "事件等级")
    private String eventLevel;

    /** 事件地点 */
    @Excel(name = "事件地点")
    private String eventLocation;

    /** 报案时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "报案时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportTime;

    /** 报案人 */
    @Excel(name = "报案人")
    private String reportPerson;

    /** 事件处置信息 */
    @Excel(name = "事件处置信息")
    private String eventDeal;

    /** 事件评估信息 */
    @Excel(name = "事件评估信息")
    private String eventAssessment;

    /** 所属企业 */
    @Excel(name = "所属企业")
    private String beyondEnterpriseId;

    /** 所属企业名称 */
    private String beyondEnterpriseName;

    /** 图片路径 */
    @Excel(name = "图片路径")
    private String iconUrl;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setEventId(Long eventId) 
    {
        this.eventId = eventId;
    }

    public Long getEventId() 
    {
        return eventId;
    }
    public void setEventTitle(String eventTitle) 
    {
        this.eventTitle = eventTitle;
    }

    public String getEventTitle() 
    {
        return eventTitle;
    }
    public void setEventType(String eventType) 
    {
        this.eventType = eventType;
    }

    public String getEventType() 
    {
        return eventType;
    }
    public void setEventLevel(String eventLevel) 
    {
        this.eventLevel = eventLevel;
    }

    public String getEventLevel() 
    {
        return eventLevel;
    }
    public void setEventLocation(String eventLocation) 
    {
        this.eventLocation = eventLocation;
    }

    public String getEventLocation() 
    {
        return eventLocation;
    }
    public void setReportTime(Date reportTime) 
    {
        this.reportTime = reportTime;
    }

    public Date getReportTime() 
    {
        return reportTime;
    }
    public void setReportPerson(String reportPerson) 
    {
        this.reportPerson = reportPerson;
    }

    public String getReportPerson() 
    {
        return reportPerson;
    }
    public void setEventDeal(String eventDeal) 
    {
        this.eventDeal = eventDeal;
    }

    public String getEventDeal() 
    {
        return eventDeal;
    }
    public void setEventAssessment(String eventAssessment) 
    {
        this.eventAssessment = eventAssessment;
    }

    public String getEventAssessment() 
    {
        return eventAssessment;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setIconUrl(String iconUrl) 
    {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() 
    {
        return iconUrl;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("eventId", getEventId())
            .append("eventTitle", getEventTitle())
            .append("eventType", getEventType())
            .append("eventLevel", getEventLevel())
            .append("eventLocation", getEventLocation())
            .append("reportTime", getReportTime())
            .append("reportPerson", getReportPerson())
            .append("eventDeal", getEventDeal())
            .append("eventAssessment", getEventAssessment())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("iconUrl", getIconUrl())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
