package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 企业信息对象 t_enterprise_info
 *
 * @author zehong
 * @date 2022-01-24
 */
public class TEnterpriseInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 企业id */
    private Long enterpriseId;

    /** 企业名称 */
    @Excel(name = "企业名称")
    private String enterpriseName;

    /** 注册地址 */
    @Excel(name = "注册地址")
    private String registerAddress;

    /** 法定代表人 */
    @Excel(name = "法定代表人")
    private String legalRepresentative;

    /** 经营区域 */
    @Excel(name = "经营区域")
    private String businessArea;

    /** 许可证编号 */
    @Excel(name = "许可证编号")
    private String licenseKey;

    /** 许可证有效期 */
    @Excel(name = "许可证有效期")
    private String licenseValidityTime;

    /** 年度监督检查情况 */
    @Excel(name = "年度监督检查情况")
    private String annualSupervisionInspection;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setEnterpriseId(Long enterpriseId)
    {
        this.enterpriseId = enterpriseId;
    }

    public Long getEnterpriseId()
    {
        return enterpriseId;
    }
    public void setEnterpriseName(String enterpriseName)
    {
        this.enterpriseName = enterpriseName;
    }

    public String getEnterpriseName()
    {
        return enterpriseName;
    }
    public void setRegisterAddress(String registerAddress)
    {
        this.registerAddress = registerAddress;
    }

    public String getRegisterAddress()
    {
        return registerAddress;
    }
    public void setLegalRepresentative(String legalRepresentative)
    {
        this.legalRepresentative = legalRepresentative;
    }

    public String getLegalRepresentative()
    {
        return legalRepresentative;
    }
    public void setBusinessArea(String businessArea)
    {
        this.businessArea = businessArea;
    }

    public String getBusinessArea()
    {
        return businessArea;
    }
    public void setLicenseKey(String licenseKey)
    {
        this.licenseKey = licenseKey;
    }

    public String getLicenseKey()
    {
        return licenseKey;
    }
    public void setLicenseValidityTime(String licenseValidityTime)
    {
        this.licenseValidityTime = licenseValidityTime;
    }

    public String getLicenseValidityTime()
    {
        return licenseValidityTime;
    }
    public void setAnnualSupervisionInspection(String annualSupervisionInspection)
    {
        this.annualSupervisionInspection = annualSupervisionInspection;
    }

    public String getAnnualSupervisionInspection()
    {
        return annualSupervisionInspection;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("enterpriseId", getEnterpriseId())
            .append("enterpriseName", getEnterpriseName())
            .append("registerAddress", getRegisterAddress())
            .append("legalRepresentative", getLegalRepresentative())
            .append("businessArea", getBusinessArea())
            .append("licenseKey", getLicenseKey())
            .append("licenseValidityTime", getLicenseValidityTime())
            .append("annualSupervisionInspection", getAnnualSupervisionInspection())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
