package com.zehong.system.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPlanInfo;
import com.zehong.system.service.ITPlanInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急预案Controller
 * 
 * @author zehong
 * @date 2022-02-11
 */
@RestController
@RequestMapping("/system/planInfo")
public class TPlanInfoController extends BaseController
{
    @Autowired
    private ITPlanInfoService tPlanInfoService;

    /**
     * 查询应急预案列表
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPlanInfo tPlanInfo)
    {
        startPage();
        List<TPlanInfo> list = tPlanInfoService.selectTPlanInfoList(tPlanInfo);
        return getDataTable(list);
    }

    /**
     * 导出应急预案列表
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:export')")
    @Log(title = "应急预案", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPlanInfo tPlanInfo)
    {
        List<TPlanInfo> list = tPlanInfoService.selectTPlanInfoList(tPlanInfo);
        ExcelUtil<TPlanInfo> util = new ExcelUtil<TPlanInfo>(TPlanInfo.class);
        return util.exportExcel(list, "应急预案数据");
    }

    /**
     * 获取应急预案详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:query')")
    @GetMapping(value = "/{planId}")
    public AjaxResult getInfo(@PathVariable("planId") Long planId)
    {
        return AjaxResult.success(tPlanInfoService.selectTPlanInfoById(planId));
    }

    /**
     * 新增应急预案
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:add')")
    @Log(title = "应急预案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPlanInfo tPlanInfo)
    {
        return toAjax(tPlanInfoService.insertTPlanInfo(tPlanInfo));
    }

    /**
     * 修改应急预案
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:edit')")
    @Log(title = "应急预案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPlanInfo tPlanInfo)
    {
        return toAjax(tPlanInfoService.updateTPlanInfo(tPlanInfo));
    }

    /**
     * 删除应急预案
     */
    @PreAuthorize("@ss.hasPermi('system:planInfo:remove')")
    @Log(title = "应急预案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{planIds}")
    public AjaxResult remove(@PathVariable Long[] planIds)
    {
        return toAjax(tPlanInfoService.deleteTPlanInfoByIds(planIds));
    }

    @GetMapping("/getEnterpris")
    public AjaxResult getEnterpris()
    {
        return AjaxResult.success(tPlanInfoService.selectEnterprise());
    }
}
