package com.zehong.web.controller.supervise;
import java.text.ParseException;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmployedPeopleInfo;
import com.zehong.system.service.ITEmployedPeopleInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 从业人员信息Controller
 *
 * @author zehong
 * @date 2022-01-25
 */
@RestController
@RequestMapping("/regulation/supervise")
public class TEmployedPeopleInfoController extends BaseController
{
    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    /**
     * 查询从业人员信息列表
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        startPage();
        List<TEmployedPeopleInfo> list = tEmployedPeopleInfoService.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
        return getDataTable(list);
    }

    /**
     * 导出从业人员信息列表
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:export')")
    @Log(title = "从业人员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmployedPeopleInfo tEmployedPeopleInfo)
    {
        List<TEmployedPeopleInfo> list = tEmployedPeopleInfoService.selectTEmployedPeopleInfoList(tEmployedPeopleInfo);
        ExcelUtil<TEmployedPeopleInfo> util = new ExcelUtil<TEmployedPeopleInfo>(TEmployedPeopleInfo.class);
        return util.exportExcel(list, "从业人员信息数据");
    }

    /**
     * 获取从业人员信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:query')")
    @GetMapping(value = "/{employedPeopleId}")
    public AjaxResult getInfo(@PathVariable("employedPeopleId") Long employedPeopleId) throws ParseException {
        TEmployedPeopleInfo tEmployedPeopleInfo = tEmployedPeopleInfoService.selectTEmployedPeopleInfoById(employedPeopleId);
        return AjaxResult.success(tEmployedPeopleInfo);
    }

    /**
     * 新增从业人员信息
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:add')")
    @Log(title = "从业人员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmployedPeopleInfo tEmployedPeopleInfo) throws ParseException {
     //根据企业id查询企业名称
     String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tEmployedPeopleInfo.getBeyondEnterpriseId());
     tEmployedPeopleInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tEmployedPeopleInfoService.insertTEmployedPeopleInfo(tEmployedPeopleInfo));
     }

     /**
     * 修改从业人员信息
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:edit')")
    @Log(title = "从业人员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmployedPeopleInfo tEmployedPeopleInfo) throws ParseException {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tEmployedPeopleInfo.getBeyondEnterpriseId());
        tEmployedPeopleInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tEmployedPeopleInfoService.updateTEmployedPeopleInfo(tEmployedPeopleInfo));
    }

    /**
     * 删除从业人员信息
     */
    @PreAuthorize("@ss.hasPermi('regulation:supervise:remove')")
    @Log(title = "从业人员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{employedPeopleIds}")
    public AjaxResult remove(@PathVariable Long[] employedPeopleIds)
    {
        return toAjax(tEmployedPeopleInfoService.deleteTEmployedPeopleInfoByIds(employedPeopleIds));
    }

    /**
     * 企业信息查询(下拉框)
     */
    @Log(title = "企业信息查询")
    @RequestMapping("/selectTEnterprise")
    public AjaxResult select(){
        return AjaxResult.success(tEmployedPeopleInfoService.selectTEnterprise());
    }

}
