package com.zehong.web.controller.supervise;

import java.util.List;

import com.zehong.system.domain.Listaw;
import com.zehong.system.domain.TDetailInfoList;
import com.zehong.system.domain.TDeviceInfoS;
import com.zehong.system.service.ITEmployedPeopleInfoService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.service.ITDeviceInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 设备信息Controller
 *
 * @author zehong
 * @date 2022-01-27
 */
@RestController
@RequestMapping("/device/device")
public class TDeviceInfoController extends BaseController
{
    @Autowired
    private ITDeviceInfoService tDeviceInfoService;

    @Autowired
    private ITEmployedPeopleInfoService tEmployedPeopleInfoService;

    /**
     * 查询设备信息列表
     */
    @PreAuthorize("@ss.hasPermi('device:device:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDeviceInfo tDeviceInfo)
    {
        startPage();
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        return getDataTable(list);
    }

    /**
     * 导出设备信息列表
     */
    @PreAuthorize("@ss.hasPermi('device:device:export')")
    @Log(title = "设备信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDeviceInfo tDeviceInfo)
    {
        List<TDeviceInfo> list = tDeviceInfoService.selectTDeviceInfoList(tDeviceInfo);
        ExcelUtil<TDeviceInfo> util = new ExcelUtil<TDeviceInfo>(TDeviceInfo.class);
        return util.exportExcel(list, "设备信息数据");
    }

    /**
     * 获取设备信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('device:device:query')")
    @GetMapping(value = "/{deviceId}")
    public AjaxResult getInfo(@PathVariable("deviceId") Long deviceId)
    {
        return AjaxResult.success(tDeviceInfoService.selectTDeviceInfoById(deviceId));
    }

    /**
     * 新增设备信息
     */
    @PreAuthorize("@ss.hasPermi('device:device:add')")
    @Log(title = "设备信息", businessType = BusinessType.INSERT)
    @PostMapping
    public void add(@RequestBody Listaw listaw)
    {
        //添加设备信息表数据 并且返回新增id
        tDeviceInfoService.insertTDeviceInfo(listaw.gettDeviceInfo());
        if (listaw.gettDeviceInfoS()!=null){
            //将关联设备信息与设备进行绑定
            tDeviceInfoService.updatetRelationDeviceDetailInfo(listaw.gettDeviceInfoS(),listaw.gettDeviceInfo().getDeviceId(),listaw.gettDeviceInfo().getRelationDeviceType());
        }
        TDeviceInfo tDeviceInfo = new TDeviceInfo();
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tDeviceInfo.getBeyondEnterpriseId());
        tDeviceInfo.setBeyondEnterpriseName(EnterpriseName);
    }

    /**
     * 修改设备信息
     */
    @PreAuthorize("@ss.hasPermi('device:device:edit')")
    @Log(title = "设备信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDeviceInfo tDeviceInfo)
    {
        //根据企业id查询企业名称
        String EnterpriseName = tEmployedPeopleInfoService.selectEnterpriseName(tDeviceInfo.getBeyondEnterpriseId());
        tDeviceInfo.setBeyondEnterpriseName(EnterpriseName);
        return toAjax(tDeviceInfoService.updateTDeviceInfo(tDeviceInfo));
    }

    /**
     * 删除设备信息
     */
    @PreAuthorize("@ss.hasPermi('device:device:remove')")
    @Log(title = "设备信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{deviceIds}")
    public AjaxResult remove(@PathVariable Long[] deviceIds)
    {
        return toAjax(tDeviceInfoService.deleteTDeviceInfoByIds(deviceIds));
    }


    /**
     * 获取设备详细信息列表
     */
    @PreAuthorize("@ss.hasPermi('device:device:deviceDetailInfo')")
    @GetMapping("/getdeviceDetailInfo")
    public AjaxResult getdeviceDetailInfo(Long deviceId) {
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.getdeviceDetailInfo(deviceId);
        return AjaxResult.success(tDeviceInfoS);
    }


    /**
     * 查询无绑定的 关联设备信息
     * @return
     */
    @RequestMapping("/selectDetailInfo")
    public TableDataInfo selectDetailInfo(@RequestBody  TDeviceInfoS tDeviceInfos){
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.selectDetailInfo(tDeviceInfos);
        return getDataTable(tDeviceInfoS);
    }

    /**
     * 添加关联设备数据接口
     */
    @RequestMapping("/insertDetailInfo")
    public void insertDetailInfo(@RequestBody TDeviceInfoS tDeviceInfoS){
        //添加关联设备信息表数据
        tDeviceInfoService.insertDeviceDetailInfo(tDeviceInfoS);
    }

    /**
     * 关联设备数据删除接口
     */
    @RequestMapping("/deleteDetailInfo")
    public void deleteDetailInfo(@RequestBody  int deviceId){
        tDeviceInfoService.deleteDetailinfOS(deviceId);
    }

    /**
     * 解绑 设备与关联设备关系
     * @param deviceId
     */
    @RequestMapping("/deleteDeviceDetailInfo")
    public void  deleteDeviceDetailInfo(@RequestBody int deviceId){
        tDeviceInfoService.deleteDeviceDetailInfo(deviceId);
    }

    /**
     * 关联设备批量数据删除接口
     * @param deviceId
     */
    @RequestMapping("/deleteeListDetailInfo")
    public void deleteeListDetailInfo(@RequestBody  Long[] deviceId){
        tDeviceInfoService.deleteDetailInfo(deviceId);
    }


    /**
     * 查询设备已经关联的关联设备接口
     * @param tDetailInfoList
     * @return
     */
    @RequestMapping("/selectDetailInfoList")
    public TableDataInfo selectDetailInfoList(@RequestBody TDetailInfoList tDetailInfoList){
        List<TDeviceInfoS> tDeviceInfoS = tDeviceInfoService.selectDetailInfoList(tDetailInfoList.getId(),tDetailInfoList.getRelationDeviceType());
        return getDataTable(tDeviceInfoS);
    }

    /**
     * 关联设备绑定接口
     * @param listaw
     */
    @RequestMapping("/updateDetailInfoList")
    public void updateDetailInfoList(@RequestBody Listaw listaw){
        Long id;
        if (null!=listaw.gettDeviceInfo().getDeviceId()){
            id=listaw.gettDeviceInfo().getDeviceId();
        }else {
            id=listaw.gettDeviceInfo().getSiteStationId();
        }
        if (!"null".equals(listaw.gettDeviceInfoS())){
            //将关联设备信息与设备进行绑定
            tDeviceInfoService.updatetRelationDeviceDetailInfo(listaw.gettDeviceInfoS(),id,listaw.gettDeviceInfo().getRelationDeviceType());
        }
    }

}
