package com.zehong.web.controller.standingBook;

import java.util.List;

import com.zehong.system.domain.form.THiddenDangerStandingBookForm;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.THiddenDangerStandingBook;
import com.zehong.system.service.ITHiddenDangerStandingBookService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患整治台账Controller
 * 
 * @author zehong
 * @date 2022-02-09
 */
@RestController
@RequestMapping("/standingBook/hidden")
public class THiddenDangerStandingBookController extends BaseController
{
    @Autowired
    private ITHiddenDangerStandingBookService tHiddenDangerStandingBookService;

    /**
     * 查询隐患整治台账列表
     */
    @PreAuthorize("@ss.hasPermi('standingBook:hidden:list')")
    @GetMapping("/list")
    public TableDataInfo list(THiddenDangerStandingBookForm tHiddenDangerStandingBook)
    {
        startPage();
        List<THiddenDangerStandingBook> list = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);
        return getDataTable(list);
    }

    /**
     * 导出隐患整治台账列表
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(THiddenDangerStandingBookForm tHiddenDangerStandingBook)
    {
        List<THiddenDangerStandingBook> list = tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookList(tHiddenDangerStandingBook);
        ExcelUtil<THiddenDangerStandingBook> util = new ExcelUtil<THiddenDangerStandingBook>(THiddenDangerStandingBook.class);
        return util.exportExcel(list, "隐患整治台账数据");
    }

    /**
     * 获取隐患整治台账详细信息
     */
    @GetMapping(value = "/{hiddenId}")
    public AjaxResult getInfo(@PathVariable("hiddenId") Long hiddenId)
    {
        return AjaxResult.success(tHiddenDangerStandingBookService.selectTHiddenDangerStandingBookById(hiddenId));
    }

    /**
     * 新增隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        return toAjax(tHiddenDangerStandingBookService.insertTHiddenDangerStandingBook(tHiddenDangerStandingBook));
    }

    /**
     * 修改隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody THiddenDangerStandingBook tHiddenDangerStandingBook)
    {
        return toAjax(tHiddenDangerStandingBookService.updateTHiddenDangerStandingBook(tHiddenDangerStandingBook));
    }

    /**
     * 删除隐患整治台账
     */
    @Log(title = "隐患整治台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{hiddenIds}")
    public AjaxResult remove(@PathVariable Long[] hiddenIds)
    {
        return toAjax(tHiddenDangerStandingBookService.deleteTHiddenDangerStandingBookByIds(hiddenIds));
    }
}
