package com.zehong.web.controller.operationMonitor;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.SysPost;
import com.zehong.system.service.ISysPostService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkOrder;
import com.zehong.system.service.ITWorkOrderService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气任务Controller
 * 
 * @author zehong
 * @date 2022-02-10
 */
@RestController
@RequestMapping("/system/order")
public class TWorkOrderController extends BaseController
{
    @Autowired
    private ITWorkOrderService tWorkOrderService;

    @Autowired
    private ISysPostService iSysPostService;

    /**
     * 查询燃气任务列表
     */
    @PreAuthorize("@ss.hasPermi('system:order:list')")
    @GetMapping("/list")
    public TableDataInfo list(TWorkOrder tWorkOrder)
    {
        startPage();
        judgeUserRole(tWorkOrder);
        List<TWorkOrder> list = tWorkOrderService.selectTWorkOrderList(tWorkOrder);
        return getDataTable(list);
    }

    /**
     * 导出燃气任务列表
     */
    @PreAuthorize("@ss.hasPermi('system:order:export')")
    @Log(title = "燃气任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkOrder tWorkOrder)
    {
        judgeUserRole(tWorkOrder);
        List<TWorkOrder> list = tWorkOrderService.selectTWorkOrderList(tWorkOrder);
        ExcelUtil<TWorkOrder> util = new ExcelUtil<TWorkOrder>(TWorkOrder.class);
        return util.exportExcel(list, "燃气任务数据");
    }

    /**
     * 判断用户角色
     * @param tWorkOrder
     */
    private void judgeUserRole(TWorkOrder tWorkOrder){
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取用户所属单位
        long enterpriseId = user.getDeptId();
        //判断是否为政府用户
        if(!"-2".equals(String.valueOf(enterpriseId))){
            tWorkOrder.setWorkAssignEnterproseId(enterpriseId);
            //判断是否为巡线员
            List<Integer> postIds = iSysPostService.selectPostListByUserId(user.getUserId());
            for(Integer postId : postIds){
                SysPost postInfo = iSysPostService.selectPostById(postId.longValue());
                if("se".equals(postInfo.getPostCode())){
                    tWorkOrder.setWorkAssignManId(user.getUserId());
                }
            }
        }
    }

    /**
     * 获取燃气任务详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:order:query')")
    @GetMapping(value = "/{workId}")
    public AjaxResult getInfo(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tWorkOrderService.selectTWorkOrderById(workId));
    }

    /**
     * 新增燃气任务
     */
    @PreAuthorize("@ss.hasPermi('system:order:add')")
    @Log(title = "燃气任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkOrder tWorkOrder)
    {
        return toAjax(tWorkOrderService.insertTWorkOrder(tWorkOrder));
    }

    /**
     * 修改燃气任务
     */
    @PreAuthorize("@ss.hasPermi('system:order:edit')")
    @Log(title = "燃气任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkOrder tWorkOrder)
    {
        return toAjax(tWorkOrderService.updateTWorkOrder(tWorkOrder));
    }

    /**
     * 删除燃气任务
     */
    @PreAuthorize("@ss.hasPermi('system:order:remove')")
    @Log(title = "燃气任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workIds}")
    public AjaxResult remove(@PathVariable Long[] workIds)
    {
        return toAjax(tWorkOrderService.deleteTWorkOrderByIds(workIds));
    }
}
