package com.zehong.web.controller.complainDeal;

import java.util.Date;
import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TComplainDeal;
import com.zehong.system.service.ITComplainDealService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.servlet.http.HttpServletRequest;

/**
 * 投诉处置Controller
 * 
 * @author zehong
 * @date 2022-02-15
 */
@RestController
@RequestMapping("/complainDeal")
public class TComplainDealController extends BaseController
{
    @Autowired
    private ITComplainDealService tComplainDealService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询投诉处置列表
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:list')")
    @GetMapping("/list")
    public TableDataInfo list(TComplainDeal tComplainDeal, HttpServletRequest request)
    {
        LoginUser loginUser = tokenService.getLoginUser(request);
        if(loginUser.getUser().getDeptId()!=-2){
            tComplainDeal.setComplainAssignEnterproseId(loginUser.getUser().getDeptId());
        }
        startPage();
        List<TComplainDeal> list = tComplainDealService.selectTComplainDealList(tComplainDeal);
        return getDataTable(list);
    }

    /**
     * 导出投诉处置列表
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:export')")
    @Log(title = "投诉处置", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TComplainDeal tComplainDeal)
    {
        List<TComplainDeal> list = tComplainDealService.selectTComplainDealList(tComplainDeal);
        ExcelUtil<TComplainDeal> util = new ExcelUtil<TComplainDeal>(TComplainDeal.class);
        return util.exportExcel(list, "投诉处置数据");
    }

    /**
     * 获取投诉处置详细信息
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:query')")
    @GetMapping(value = "/{complainDealId}")
    public AjaxResult getInfo(@PathVariable("complainDealId") Long complainDealId)
    {
        return AjaxResult.success(tComplainDealService.selectTComplainDealById(complainDealId));
    }

    /**
     * 新增投诉处置
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:add')")
    @Log(title = "投诉处置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TComplainDeal tComplainDeal)
    {
        return toAjax(tComplainDealService.insertTComplainDeal(tComplainDeal));
    }

    /**
     * 修改投诉处置
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:edit')")
    @Log(title = "投诉处置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TComplainDeal tComplainDeal)
    {
        if(tComplainDeal.getComplainStatus().equals("2")){
            tComplainDeal.setDealTime(new Date());
        }
        return toAjax(tComplainDealService.updateTComplainDeal(tComplainDeal));
    }

    /**
     * 删除投诉处置
     */
    @PreAuthorize("@ss.hasPermi('complainDeal:complainDeal:remove')")
    @Log(title = "投诉处置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{complainDealIds}")
    public AjaxResult remove(@PathVariable Long[] complainDealIds)
    {
        return toAjax(tComplainDealService.deleteTComplainDealByIds(complainDealIds));
    }


    @GetMapping("/getuserList/{enterproseId}")
    public AjaxResult selectUserByenterproseId(@PathVariable("enterproseId") String enterproseId)
    {
        return AjaxResult.success(tComplainDealService.selectUserByenterproseId(enterproseId));
    }

}
